<?LassoScript

	// Initialization
	//
	// This page initializes the example.  It authenticates the user and sets up
	// the required databases, tables, and groups.

	// For debugging the log level can be modified to sql
	var: 'log_level' = 'none';
	
	// Database and Group
	//
	// The [Application_Initialize] tag is used to create the database, tables, and
	// group required by the Poll example.  The following structure is created.
	//
	// op_collaborate
	//
	//  prefs
	//    id
	//    title - The title for the site
	//    header - The site header
	//    footer - The site footer
	//    prefs - global preferences stores serialized map
	//
	//  pages
	//    id
	//    section_id - relation
	//    title - page title
	//    code - code for url navigation
	//    sort - numeric order
	//    status - true = visible, false = hidden
	//    body - page body
	//    prefs - page preferences stores serialized map
	//
	//  sections - every page must be in a section
	//    id
	//    title - section title
	//    code - code for url navigation
	//    sort - numeric order
	//    header - header to display on all pages in this section
	//    footer - footer to display on all pages in this section
	//    prefs - section preferences stores serialized map
	//
	
	if: ((Application_WasInitialized: -AppName=Application_AppInfo->Title, -Version=Application_AppInfo->Version) == false);

		// Only a site administrator can initialize this application.
		auth_admin;
	
		var: 'initializeResults'=(Application_Initialize: 
			-AppName=Application_AppInfo->Title,
			-Version=Application_AppInfo->Version,
			-Config=(Array: 
				-Group=(Pair: 'OP Collaborate Admins'='Users which are allowed to administer the collaborate system.'),
				-Database=(Pair: 'op_collaborate'=(Array:
					-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X'),
					-Table=(Pair: 'prefs'=(Array: 
						-SQL='CREATE TABLE prefs ( \
							id INTEGER PRIMARY KEY, \
							title TEXT, \
							header TEXT, \
							footer TEXT, \
							prefs TEXT DEFAULT "<mapType></mapType>")',
						-group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
					-Table=(Pair: 'sections'=(Array: 
						-SQL='CREATE TABLE sections ( \
							id INTEGER PRIMARY KEY, \
							title TEXT, \
							status TEXT DEFAULT "Y", \
							code TEXT, \
							sort INTEGER, \
							header TEXT, \
							footer TEXT, \
							prefs TEXT DEFAULT "<mapType></mapType>");',
						-SQL='CREATE INDEX code ON sections (code)',
						-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
					-Table=(Pair: 'pages'=(Array: 
						-SQL='CREATE TABLE pages ( \
							id INTEGER PRIMARY KEY, \
							section_id INTEGER, \
							title TEXT, \
							status TEXT DEFAULT "Y", \
							code TEXT, \
							sort INTEGER, \
							body TEXT, \
							prefs TEXT DEFAULT "<mapType></mapType>");',
						-SQL='CREATE INDEX code ON pages (code)',
						-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
				))
			)
		);

		// if the application was just now initialized, add a starter section and page
		if ($initializeResults->size);
			inline: -log=$log_level,
					-findall,
					-database='op_collaborate',
					-table='prefs';
				if: (found_count == 0);
					var: 'site_prefs' = (map:
						'site_header_textalign'='center',
						'site_header_fontsize'='24px',
						'site_header_fontweight'='bold',
						'site_footer_textalign'='center',
						'site_footer_fontsize'='12px',					
					);
					var: 'section_prefs' = (map:
						'section_header_textalign'='center',
						'section_header_fontsize'='20px',
						'section_header_fontweight'='bold',
						'section_footer_textalign'='center',
						'section_footer_fontsize'='12px',					
					);
					var: 'page_prefs' = (map);
					inline: -log_level=$log_level,
							-sql='\
							INSERT INTO prefs VALUES (1,"Examples Pack - Collaborate","Collaborate","","' + (string_replace: (encode_sql92: $site_prefs->serialize), -find='"', -replace='""') + '"); \
							INSERT INTO sections VALUES (1,"Welcome","Y","Default",1,"Welcome to Collaborate","<hr />Headers and footers can be added which appear above and below the contents of each page in a section.","' + (string_replace: (encode_sql92: $section_prefs->serialize), -find='"', -replace='""') + '"); \
							INSERT INTO pages VALUES (1,1,"Introduction","Y","Default",1,"<p>This example allows a simple Web site to be created completely through the Web browser.  Use the Edit This Page link below to access the editing interface.</p><p>The navigation to the left shows the current structure of the site.  You can easily create new sections and pages to quickly build a complex site.</p>","' + (string_replace: (encode_sql92: $page_prefs->serialize), -find='"', -replace='""') + '"); \
						';
					/inline;
				/if;
			/inline;
		/if;
	/if;
		
?>
